/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;

public class CumulativeDistribution<T> {
    private Array<CumulativeValue> values = new Array(false, 10, CumulativeValue.class);

    public void add(T value2, float intervalSize) {
        this.values.add(new CumulativeValue(value2, 0.0f, intervalSize));
    }

    public void add(T value2) {
        this.values.add(new CumulativeValue(value2, 0.0f, 0.0f));
    }

    public void generate() {
        float sum2 = 0.0f;
        for (int i = 0; i < this.values.size; ++i) {
            ((CumulativeValue[])this.values.items)[i].frequency = sum2 += ((CumulativeValue[])this.values.items)[i].interval;
        }
    }

    public void generateNormalized() {
        float sum2 = 0.0f;
        for (int i = 0; i < this.values.size; ++i) {
            sum2 += ((CumulativeValue[])this.values.items)[i].interval;
        }
        float intervalSum = 0.0f;
        for (int i = 0; i < this.values.size; ++i) {
            ((CumulativeValue[])this.values.items)[i].frequency = intervalSum += ((CumulativeValue[])this.values.items)[i].interval / sum2;
        }
    }

    public void generateUniform() {
        float freq2 = 1.0f / (float)this.values.size;
        for (int i = 0; i < this.values.size; ++i) {
            ((CumulativeValue[])this.values.items)[i].interval = freq2;
            ((CumulativeValue[])this.values.items)[i].frequency = (float)(i + 1) * freq2;
        }
    }

    public T value(float probability) {
        CumulativeValue value2 = null;
        int imax = this.values.size - 1;
        int imin = 0;
        while (imin <= imax) {
            int imid = imin + (imax - imin) / 2;
            value2 = ((CumulativeValue[])this.values.items)[imid];
            if (probability < value2.frequency) {
                imax = imid - 1;
                continue;
            }
            if (!(probability > value2.frequency)) break;
            imin = imid + 1;
        }
        return ((CumulativeValue[])this.values.items)[imin].value;
    }

    public T value() {
        return this.value(MathUtils.random());
    }

    public int size() {
        return this.values.size;
    }

    public float getInterval(int index2) {
        return ((CumulativeValue[])this.values.items)[index2].interval;
    }

    public T getValue(int index2) {
        return ((CumulativeValue[])this.values.items)[index2].value;
    }

    public void setInterval(T obj, float intervalSize) {
        for (CumulativeValue value2 : this.values) {
            if (value2.value != obj) continue;
            value2.interval = intervalSize;
            return;
        }
    }

    public void setInterval(int index2, float intervalSize) {
        ((CumulativeValue[])this.values.items)[index2].interval = intervalSize;
    }

    public void clear() {
        this.values.clear();
    }

    public class CumulativeValue {
        public T value;
        public float frequency;
        public float interval;

        public CumulativeValue(T value2, float frequency, float interval) {
            this.value = value2;
            this.frequency = frequency;
            this.interval = interval;
        }
    }
}

